//
//  FirstViewController.swift
//  AssetBrowser
//
//  Created by Jan-Peter Krämer on 28/12/15.
//  Copyright © 2015 RWTH Aachen University. All rights reserved.
//

import UIKit
import PhotosUI
import MobileCoreServices

class FirstViewController: UIViewController {
	@IBOutlet weak var imageView: UIImageView!
	@IBOutlet weak var toolbar: UIToolbar!
	
	override func viewDidLoad() {
		super.viewDidLoad()
		
		if (!UIImagePickerController.isSourceTypeAvailable(.Camera)) {
			toolbar.items?.removeAtIndex(0)
		}
		// Do any additional setup after loading the view, typically from a nib.
	}

	override func didReceiveMemoryWarning() {
		super.didReceiveMemoryWarning()
		// Dispose of any resources that can be recreated.
	}

	@IBAction func takePicture(sender: AnyObject) {
		showImagePicker(.Camera)
	}
	
	@IBAction func selectFromLibrary(sender: AnyObject) {
		showImagePicker(.PhotoLibrary)
	}

	private func showImagePicker(sourceType: UIImagePickerControllerSourceType) {
		let imagePickerController = UIImagePickerController()
		imagePickerController.modalPresentationStyle = .CurrentContext
		imagePickerController.sourceType = sourceType
		imagePickerController.delegate = self
		imagePickerController.allowsEditing = true
		imagePickerController.mediaTypes = [kUTTypeImage as String]
		
		self.presentViewController(imagePickerController, animated: true, completion: nil)
	}
}

extension FirstViewController : UIImagePickerControllerDelegate {
	func imagePickerController(picker: UIImagePickerController, didFinishPickingMediaWithInfo info: [String : AnyObject]) {
		if let image = info[UIImagePickerControllerOriginalImage] as? UIImage {
			self.imageView.image = image
		}
		
		self.dismissViewControllerAnimated(true, completion: nil)
	}
	
	func imagePickerControllerDidCancel(picker: UIImagePickerController) {
		self.dismissViewControllerAnimated(true, completion: nil)
	}
}

extension FirstViewController : UINavigationControllerDelegate {}

